/*
 * Decompiled with CFR 0.152.
 */
package processing.awt;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import processing.core.PImage;

public class PImageAWT
extends PImage {
    public PImageAWT(Image img) {
        this.format = 1;
        if (img instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)img;
            this.width = bi.getWidth();
            this.height = bi.getHeight();
            int type = bi.getType();
            if (type == 5 || type == 6) {
                this.pixels = new int[this.width * this.height];
                bi.getRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
                if (type == 6) {
                    this.format = 2;
                } else {
                    this.opaque();
                }
            } else {
                DataBuffer db = bi.getRaster().getDataBuffer();
                if (db instanceof DataBufferInt) {
                    this.pixels = ((DataBufferInt)db).getData();
                    if (type == 2) {
                        this.format = 2;
                    } else if (type == 1) {
                        this.opaque();
                    }
                }
            }
        }
        if (this.pixels == null) {
            this.width = img.getWidth(null);
            this.height = img.getHeight(null);
            this.pixels = new int[this.width * this.height];
            PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.pixelDensity = 1;
        this.pixelWidth = this.width;
        this.pixelHeight = this.height;
    }

    protected void opaque() {
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = 0xFF000000 | this.pixels[i];
        }
    }

    @Override
    public Image getImage() {
        return (Image)this.getNative();
    }

    @Override
    public Object getNative() {
        this.loadPixels();
        int type = this.format == 1 ? 1 : 2;
        BufferedImage image = new BufferedImage(this.pixelWidth, this.pixelHeight, type);
        WritableRaster wr = image.getRaster();
        wr.setDataElements(0, 0, this.pixelWidth, this.pixelHeight, this.pixels);
        return image;
    }

    @Override
    public void resize(int w, int h) {
        float diff;
        if (w <= 0 && h <= 0) {
            throw new IllegalArgumentException("width or height must be > 0 for resize");
        }
        if (w == 0) {
            diff = (float)h / (float)this.height;
            w = (int)((float)this.width * diff);
        } else if (h == 0) {
            diff = (float)w / (float)this.width;
            h = (int)((float)this.height * diff);
        }
        BufferedImage img = PImageAWT.shrinkImage((BufferedImage)this.getNative(), w * this.pixelDensity, h * this.pixelDensity);
        PImageAWT temp = new PImageAWT(img);
        this.pixelWidth = temp.width;
        this.pixelHeight = temp.height;
        this.pixels = temp.pixels;
        this.width = this.pixelWidth / this.pixelDensity;
        this.height = this.pixelHeight / this.pixelDensity;
        this.updatePixels();
    }

    private static BufferedImage shrinkImage(BufferedImage img, int targetWidth, int targetHeight) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage outgoing = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = outgoing.getWidth();
        int prevH = outgoing.getHeight();
        boolean isTranslucent = img.getTransparency() != 1;
        int w = img.getWidth();
        int h = img.getHeight();
        do {
            if (w > targetWidth) {
                if ((w /= 2) < targetWidth) {
                    w = targetWidth;
                }
            } else if (targetWidth >= w) {
                w = targetWidth;
            }
            if (h > targetHeight) {
                if ((h /= 2) < targetHeight) {
                    h = targetHeight;
                }
            } else if (targetHeight >= h) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(outgoing, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            outgoing = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != outgoing.getWidth() || targetHeight != outgoing.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)outgoing, 0, 0, null);
            g2.dispose();
            outgoing = scratchImage;
        }
        return outgoing;
    }
}

